const API_BASE = "https://cockpit.haakworks.de"; // Cockpit-URL

const extApi = typeof browser !== "undefined" ? browser : chrome;

async function loadTools() {
  const statusEl = document.getElementById("status");
  const contentEl = document.getElementById("content");

  try {
    statusEl.textContent = "Lade Daten…";

    const res = await fetch(`${API_BASE}/api/tools`, {
      method: "GET",
      credentials: "include" // Session-Cookies mit senden
    });

    if (!res.ok) {
      throw new Error(`HTTP ${res.status}`);
    }

    const data = await res.json();

    if (!Array.isArray(data) || data.length === 0) {
      statusEl.textContent = "Keine Tools gefunden. Öffne Cockpit und lege Bereiche/Tools an.";
      return;
    }

    statusEl.textContent = "";
    renderTools(data, contentEl);
  } catch (err) {
    console.error(err);
    statusEl.innerHTML = "Fehler beim Laden der Tools.<br>Stelle sicher, dass du in Cockpit angemeldet bist und die URL in der Extension stimmt.";
  }
}

function renderTools(areas, container) {
  container.innerHTML = "";

  areas.forEach(area => {
    const areaDiv = document.createElement("div");
    areaDiv.className = "area";

    const header = document.createElement("div");
    header.className = "area-header";

    const colorDot = document.createElement("div");
    colorDot.className = "area-color";
    if (area.color) {
      colorDot.style.backgroundColor = area.color;
    } else {
      colorDot.style.backgroundColor = "#4b5563";
    }

    const title = document.createElement("div");
    title.className = "area-title";
    title.textContent = area.name;

    header.appendChild(colorDot);
    header.appendChild(title);
    areaDiv.appendChild(header);

    (area.tools || []).forEach(tool => {
      const toolRow = document.createElement("div");
      toolRow.className = "tool-link";

      const nameSpan = document.createElement("span");
      nameSpan.textContent = tool.name;

      toolRow.appendChild(nameSpan);

      toolRow.addEventListener("click", () => {
        if (tool.url) {
          extApi.tabs.create({ url: tool.url });
        }
      });

      areaDiv.appendChild(toolRow);

      if (tool.tags && tool.tags.length > 0) {
        const tagsDiv = document.createElement("div");
        tagsDiv.className = "tags";

        tool.tags.forEach(tag => {
          const tagSpan = document.createElement("span");
          tagSpan.className = "tag";
          tagSpan.textContent = tag.name;
          tagsDiv.appendChild(tagSpan);
        });

        areaDiv.appendChild(tagsDiv);
      }
    });

    container.appendChild(areaDiv);
  });
}

loadTools();
